if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

local input_1 = resize.location.std.generators[1].generate:translate(Vector.new(2, 0))

local default_vertical = 0
set_default_vertical(default_vertical)

function info_filter(i)
  return i.type == "InterfaceKeyEventAction" and i ~= PlayerInteraction.pause and i ~= PlayerInteraction.stop
end

local side_hint = make_dynamic_hint(Hint.tutorial)

function info_tab_arrow(c, fade)
  local pos = Vectord.new(c.aspect - 0.11, 1 - 0.17)
  draw_arrow_at(
    c,
    pos,
    0.06 - 0.04 * bouncing_at_time(fade.total),
    0.06,
    RIGHT,
    {1, 1, 1, fade.progress}
  )
end

set_user_input_filter(permissive_filter)
function tutorial_routine()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    state:suppress_toolbar_menu();
    state:suppress_transport_menu();
    state:suppress_interface_hints();
    embed(ramp(5, do_all(
      announce_lambda("This stage has a randomized input.", 0.09),
      bouncing_arrow_at_game_lambda(input_1, 0.06, LEFT)
    ), captured_cancel()))
    set_user_input_filter(info_filter)
    embed(ramp_until(function() return state:is_info_tab_open() end, do_all(
      announce_lambda("The info tab describes such inputs.", 0.09),
      announce_lambda("Open it now.", 0.08, default_vertical - 0.09),
      announce_lambda("(Click in top right or press 'i')", 0.05, default_vertical - 0.16),
      info_tab_arrow
    )))
    set_user_input_filter(permissive_filter)
    side_hint("This tab describes all the important specifications of a level.\n\nClose it by clicking the info button again, or pressing Escape or 'i'")
    embed(pause_until(function() return not state:is_info_tab_open() end))
    side_hint(nil)
    state:suppress_interface_hints(false);
    state:suppress_transport_menu(false);
    state:suppress_toolbar_menu(false);
    embed(pause(0.5))
    embed(announce("Good luck!", 3, 0.15, captured_cancel()))
  end)
end
if not played_in_past then
  draw_interpreted_routine(tutorial_routine())
end
